/*
  file: crusade_script_procs.h
  purpose: Public functions which can be accessed from inside the script

  Author: David Grace
  Creation: 08/04/2002


*/


/* System related -----------------------
   |
   |
*/
import int rand() ;
import int abs (int var) ;

/* Allegro related -----------------------
   |
   |
*/
import void allegro_message (char *msg, ...) ;   // use this for script debugging

/* Crusade related -----------------------
   |
   |
*/
// create a new object of type "objname"
import tobjdef *create_object (char *objname, int x, int y, int stype) ;  
// sets the animation sequence frame to "frame"
import void set_ani_frame (tobjdef *data, int frame) ;
// sets the currently playing animation called "aniname" on the object, starting at "frame"
import void set_animation (tobjdef *data, char *aniname, int frame) ;
// flashes an object white (sets animation to ANIEFFECT_WHITE), will restore after 5 ticks
import void flash (tobjdef *data) ;
// check to see if an object exists
import int obj_exists (tobjdef *ptr) ;
// creates particle effects
import void add_particle (int x, int y, int type, int velocity, int angle) ;
// move along an angle (modifies "self" as needed)
import void move_angle (tobjdef *self, float velocity) ;
// find angle between first and second set of coords
import int calculate_angle (int x1, int y1, int x2, int y2) ;
// debug text function
import void show_dtext (int x, int y, char *msg, ...) ;
import void fire_enemy_bullet (tobjdef *obj, int x, int y, int type, int angle, int speed) ;

import int onscreen (tobjdef *ptr) ;
import void hurt_player (tobjdef *ptr, int amount) ;
import void play_snd (int sndeffect, int vol, int speed) ;
import void play_snd_loop (int sndeffect, int vol, int speed) ;
import void stop_snd (int sndeffect) ;
import void turn_toward (tobjdef *ptr, unsigned char angle, int speed) ;

import int cfcos (unsigned char angle, float offset) ;
import int cfsin (unsigned char angle, float offset) ;
import void shake_screen (int duration) ;

import void start_conversation (char *anifile, char *voicefile, char *speech) ;
import void stop_conversation () ;
import void endlevel () ;
import void add_jetflame (tobjdef *self, int xo, int yo, int angleoffset) ;

import void scroll_map (int xoff, int yoff) ;


// variables
import tobjdef *playerdatap ;
import void *playerp ;
import int *levelvarp ;
import void *levelobjp ;
import unsigned int heartbeat ;
import unsigned int checkpoint ;
import int engineflare ;
import int conversation ;
import int map_offsetx ;
import int map_offsety ;

// Level Definitions
import unsigned int levelcounter ;